#NoTrayIcon
#RequireAdmin
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Res_Comment=Diablo 2 IP Finder
#AutoIt3Wrapper_Res_Description=IP Finder
#AutoIt3Wrapper_Res_Fileversion=2.2.0.0
#AutoIt3Wrapper_Res_Language=1033
#AutoIt3Wrapper_Res_requestedExecutionLevel=requireAdministrator
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
#cs ----------------------------------------------------------------------------

 AutoIt Version: 3.3.2.0

#ce ----------------------------------------------------------------------------

; Script Start - Add your code below here

;;Autoit3 libraries
#include <Date.au3>
#include <GuiConstants.au3>
#include <String.au3>
#include <WindowsConstants.au3>

;;Custom functions
#include <NomadMemory.au3>
#include <MinimizedMsg.au3>

Global Const $VersionInfo = 'KissCloneHunter 2.2'

AutoItSetOption("WinDetectHiddenText", 1)
AutoItSetOption("WinTitleMatchMode", 3)  ;; exact match

if Not ($CmdLine[$CmdLine[0]] == "launch") Then
	MsgBox(0,$VersionInfo, "This executable is run automatically, please run the regular KCH exe")
	Exit
EndIf

GUICreate("KCHClient-" & @AutoItPID,250,100)
GUICtrlCreateLabel("input",10,0,240,30) ;;input
GUICtrlCreateLabel("Startup| | |0/0",10,35,240,30) ;;output
GUICtrlCreateLabel("",10,70,240,30) ;;log stream
;~ GUISetState() ;Debug input/output

;; handle to controls in the lobby screen - from R1CH and EoN
Global $OFFSET_D2MULTI_SCREEN = 0x6FA09154
Global $OFFSET_D2MULTI_IPADDRESS_ASCII = 0x6FA2B1F8
Global $OFFSET_D2MULTI_LAST_CHAT_MSG = 0x6FBC3AB0
Global $OFFSET_GAME_PING = 0x6FBC9804
Global $OFFSET_GAMEINFO = 0x48F618
Global $OFFSET_GAMENAME = 0x1B
Global $OFFSET_GAMEPASSWORD = 0x241

Global $MESSAGE_DIABLO_WALKS_THE_EARTH = "Diablo Walks the Earth"
Global $MESSAGE_STONES_OF_JORDAN_SOLD = " Stones of Jordan Sold to Merchants"

Global $LOBBY_MAIN_CREATE_X			= 600
Global $LOBBY_MAIN_CREATE_Y			= 463
Global $LOBBY_MAIN_JOIN_X			= 706
Global $LOBBY_MAIN_JOIN_Y			= 463
Global $LOBBY_CREATE_HELL_X			= 706
Global $LOBBY_CREATE_HELL_Y			= 375
Global $LOBBY_CREATE_NORM_X			= 439
Global $LOBBY_CREATE_NORM_Y			= 375
Global $LOBBY_CREATE_X				= 706
Global $LOBBY_CREATE_Y				= 375

Global $changedip = 0
Global $oldptr1, $oldptr2, $oldmsg

Global $startinfo = 0
Global $successtotal = 0

$DebugForceFind = 0  ;; used for testing only

Global $startdelay = 0
Global $HoldGame = 0
Global $HuntPaused = 0
Global $winprocess = -1
Global $JoinGame = 0
Global $saleopt = 1

Global $stopnum, $stoptime, $stopdelay ;Settings
Global $stoptimer, $stoppedtimer ;internal timers

$UserUniqueGameName = 0
$UserUniqueGamePass = ""
$GameNumber = 0
$GameName = ""
$GamePass = ""
$joinGameName = ""
$joinGamePass = ""
$CurrentIP = 0
$IPList = 0
$FoundSoundFile = @ScriptDir & '\tada.wav'
$DroppedSoundFile = @ScriptDir & '\dropped.mp3'
$WindowName = ""

$MSG_TimeToNextGame = "Time left:"

Dim $HuntedIPs[4] ;; gets redimensioned later, but we need its scope here

$GameDurationSeconds = 180
$AdjustedGameLengthSeconds = 0

;; Note - some users (including the author) experienced, at times,
;; frequent "failed to join game" errors after a new game is created.
;; Increasing the value below might help, but my experience shows
;; that even at 10 seconds, the problem can still occur.
;; If the delay is too small (e.g., 1 second), "failed to join game"
;; errors occur almost every time. There is likely another reason
;; for this error when delay before new game is higher, possibly
;; packet-loss on the local ISP, using a character that was in a game
;; that recently crashed, etc.

$DelayBeforeNewGameSeconds = 5

$AntiIdleDelayMS = 30 * 1000  ;; 30 secs

_getwininput()
AdlibRegister("_getwininput",250)

;; must have this priv to read d2's memory
_SetPrivilege ("SeDebugPrivilege", 1)
;; wait until retrieved start info
while $startinfo = 0
	Sleep(100)
WEnd

Local $startdelaynum = 0
while $startdelaynum < $startdelay
	$startdelaynum = $startdelaynum + 1
	_winoutput("Start Delay: " & $startdelay - $startdelaynum & "| | |0/0")
	Sleep(1000)
WEnd
_winoutput("Startup| | |0/0")
if Not ($stoptime == 0) then
	$stoptimer = TimerInit()
endif

if IsGameActive() Then
	Local $val = MsgBox(3,$VersionInfo,"Error, already ingame. Continue Hunting?" & @CRLF & "Select 'YES' to exit the game, 'NO' to hold this game, or 'CANCEL' to unload")
	if $val = 2 Then
		Exit ;;cancel
	ElseIf $val = 7 Then ;;no
		getgamenamepass()
		HoldManualGame()
	elseif $val = 6 Then ;;yes
		ExitGame()
		Sleep(5000)
	EndIf
EndIf
VerifyLobbyScreenUp()
_Main()
Exit

Func _Main()
	while (1)

		CreateGame()
		$successtotal = $successtotal + 1
		Sleep(500)
		_SendMinimized($WindowName, '{TAB}')  ;; turn on the info to display gamename/etc

		;; check to see if current game's IP is in list of hunted IPs
		getgamenamepass()
		$CurrentIP = Read_Diablo_Memory (GetD2ProcessID(), $OFFSET_D2MULTI_IPADDRESS_ASCII, 'char[16]')
		_winoutput("ingame|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)

		If IsIPFound($CurrentIP) Then
			AckHuntedIPFound()
		EndIf

		;==============================
		; prepare to wait in the game
		;==============================

		;; calculate the game time in seconds
		$AdjustedGameLengthSeconds = $GameDurationSeconds - $DelayBeforeNewGameSeconds

;~ 		UnPause()
;~ 		GUICtrlSetState($PauseButton, $GUI_ENABLE)

		;; wait in the game, displaying the time remaining and the progress bar
		For $sleepSecond = $AdjustedGameLengthSeconds To 0 Step - 0.5
			_winoutput("ingame; Delay: " & Int($sleepSecond) & "|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)

			;;check if ingame and currentip is hunted
			if $changedip = 1 Then
				$changedip = 0
				if IsGameActive() Then
					If IsIPFound($CurrentIP) Then
						AckHuntedIPFound()
					EndIf
				EndIf
			EndIf

			Sleep(500)

			;; if the user pressed the pause button, the variable will be set
			While $HuntPaused = 1
				Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
				_winoutput("Paused" & StringMid($prev,StringInStr($prev,"|")))
				Sleep(500)
			WEnd
			if $JoinGame = 1 Then
				$JoinGame = 0
				_winoutput("Joining Game| | |" & $successtotal & "/" & $GameNumber)
				ExitGame()
				Sleep(5000)
				_joinGame()
			EndIf
			if $HoldGame = 1 Then
				getgamenamepass()
				HoldManualGame()
			EndIf

			;; check for SOJ sales and/or Diablo Walks here,
			;; in case it happens while we're waiting for next game
			;; (that would be bad to ignore it!)
			Local $salemsg = GetLastChatMessage()
			If $salemsg <> "" Then
				If StringCompare($salemsg, $MESSAGE_DIABLO_WALKS_THE_EARTH , 1) = 0 Then
					_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
					_loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK")
					;; only check for messages if user has requested
					If $saleopt == 1 Then InterruptHunt()
				ElseIf StringCompare(StringRight($salemsg, StringLen($MESSAGE_STONES_OF_JORDAN_SOLD)), $MESSAGE_STONES_OF_JORDAN_SOLD,1) = 0 Then
					_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringReplace($salemsg,$MESSAGE_STONES_OF_JORDAN_SOLD,"",1,1) & "|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
					_loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringReplace($salemsg,$MESSAGE_STONES_OF_JORDAN_SOLD,"",1,1))
					;; only check for messages if user has requested
					If $saleopt == 1 Then InterruptHunt()
				EndIf
			EndIf
		Next

		_stopcheck()
		ExitGame()
		For $sleepSecond = $DelayBeforeNewGameSeconds To 0 Step - 0.5
			_winoutput("lobby; Delay: " & Int($sleepSecond) & "| | |" & $successtotal & "/" & $GameNumber)
			While $HuntPaused = 1
				Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
				_winoutput("Paused" & StringMid($prev,StringInStr($prev,"|")))
				Sleep(500)
			WEnd
			if $JoinGame = 1 Then
				$JoinGame = 0
				_winoutput("Joining Game| | |" & $successtotal & "/" & $GameNumber)
				ExitGame()
				Sleep(3000)
				_joinGame()
			EndIf
			Sleep(500)
		Next

	WEnd
EndFunc

; ===========================================

Func getgamenamepass()
	$GameinfoStart = _ProcessGetLoadedModules(GetD2ProcessID())
	$Gameinfo = Read_Diablo_Memory (GetD2ProcessID(), $GameinfoStart + $OFFSET_GAMEINFO, 'dword')
	$GameinfoName = $Gameinfo + $OFFSET_GAMENAME
	$GameinfoPass = $Gameinfo + $OFFSET_GAMEPASSWORD
	$GameName = Read_Diablo_Memory (GetD2ProcessID(), $GameinfoName, 'char[24]')
	$GamePass = Read_Diablo_Memory (GetD2ProcessID(), $GameinfoPass, 'char[24]')
EndFunc

; ===========================================

Func ChangeDelay()
	Do
        $value = InputBox($VersionInfo & ": Game duration", "Please enter how many seconds (at least 10) a game should last. Note: 180 seconds is generally a safe number to avoid getting IP banned after many tries.", $GameDurationSeconds, " M","","","","",30)
		if @error = 1 Then
			Return
		EndIf
    Until (($value >= 10) AND (StringIsInt($value)))
	$GameDurationSeconds = $value
;~ 	GUICtrlSetData($GameDurationLabel, $GameDurationSeconds & " seconds")
EndFunc

; ========================================

Func CreateGame()
	VerifyLobbyScreenUp()
    Do
		;; click "Join" button (to make sure "Create" will be active; it can be grayed out after create fails)
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y,1,1)
		Sleep(400)
		;; click "Create" button
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_CREATE_X, $LOBBY_MAIN_CREATE_Y,1,1)
		Sleep(400)
        ;; click Hell level button
        _MouseClickMinimized($WindowName, "left", $LOBBY_CREATE_X, $LOBBY_CREATE_Y,1,1)
		Sleep(400)

        ;; make game name and password
        $GameNumber = $GameNumber + 1
        $GameName = $UserUniqueGameName & $GameNumber
		if $UserUniqueGamePass = "" Then
			$GamePass = $GameNumber
		Else
			$GamePass = $UserUniqueGamePass
		EndIf

		_winoutput("Creating Game: " & $GameNumber & "| | |" & $successtotal & "/" & $GameNumber)

		_SendMinimized($WindowName, $GameName & '{TAB}')
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, $GamePass)
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, '{ENTER}')

    Until IsGameCreated() = 1

    Return

EndFunc   ;==>CreateGame

; ========================================

;; logic is a bit strange here...

Func IsGameCreated()

    ; init a timer, so we can see how long this takes (for recovery)
    $TimerStart = TimerInit()

    ;; WaitForChangeInManaBall (1000, 7)  ;; milliseconds between checks, number of retries

    $RetryCount = 0
    Do
        If IsGameActive() Then
            Return 1
        EndIf
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 30


    ; Assume now that Game creation has failed and try to recover
    ; we only deal with "failed to join game" errors, so we assume that happened.
    ; All we can do is wait the gameduration or 40 seconds (so the screen goes away), because a game was created that we couldn't join
    if $GameDurationSeconds < 40 Then
		$InitSecondsRemaining = (40 - Int(TimerDiff($TimerStart) / 1000))
	Else
		$InitSecondsRemaining = ($GameDurationSeconds - Int(TimerDiff($TimerStart) / 1000))
	EndIf

;~ 	GUICtrlSetState($PauseButton, $GUI_ENABLE)
    For $sleepSecond = $InitSecondsRemaining To 0 Step - 0.5
        $percentComplete = Int(100 * ($InitSecondsRemaining - $sleepSecond) / $InitSecondsRemaining)
        _winoutput("FTJ; Delay: " & Int($sleepSecond) & "| | |" & $successtotal & "/" & $GameNumber)

		While $HuntPaused = 1
			Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
			_winoutput("Paused" & StringMid($prev,StringInStr($prev,"|")))
			Sleep(500)
		WEnd

		if $JoinGame = 1 Then
			$JoinGame = 0
			_winoutput("Joining Game| | |" & $successtotal & "/" & $GameNumber)
			ExitGame()
			Sleep(3000)
			_joinGame()
		EndIf
		if $HoldGame = 1 Then
			getgamenamepass()
			HoldManualGame()
		EndIf

		_stopcheck()
        Sleep(500)

    Next
;~     GUICtrlSetState($PauseButton, $GUI_DISABLE)
    VerifyLobbyScreenUp()

    Return 0

EndFunc   ;==>IsGameCreated

; ========================================

Func IsLobbyScreenUp()

    $ProcessID = GetD2ProcessID()

    Local $DllInformation = _MemoryOpen ($ProcessID)
    If @error Then
        MsgBox(4096, "ERROR", "Failed to open memory.")
        Exit
    EndIf

    $Value = _MemoryRead ($OFFSET_D2MULTI_SCREEN, $DllInformation, 'dword')

    ;; MsgBox(4096, "Value", $Value)

    ;##################################
    ;Close the process.
    ;##################################
    _MemoryClose ($DllInformation)
    If @error Then
        MsgBox(4096, "ERROR", "Failed to close memory.")
        Exit
    EndIf

    If $Value <> 0 Then
        Return 1
    Else
        Return 0
    EndIf

EndFunc   ;==>IsLobbyScreenUp

; ========================================

Func VerifyLobbyScreenUp()

    If Not IsLobbyScreenUp() Then
        Do
            $userResponse = MsgBox(5 + 32 + 262144, $VersionInfo & ": Problem", "Either the Lobby Screen is not active in the Diablo II window, or the Create button is grayed out and I cannot create a game." & @CRLF & "Please make sure you've opened a character in Diablo and are waiting in the lobby screen, with the Create button present and enabled.")
            If $userResponse = 2 Then
                ;; user chose to cancel, exit...
                Exit
            EndIf
        Until IsLobbyScreenUp()
    Else
;~ 		GUICtrlSetState($HoldAbandonButton,$GUI_ENABLE)
        ;; everything is good, continue on
    EndIf

EndFunc   ;==>VerifyLobbyScreenUp

; ========================================

Func GetD2ProcessID()
;~     $ProcID = WinGetProcess($WindowName)
	$ProcID = $winprocess
    If $ProcID = -1 Then
        MsgBox(4096, "ERROR", "Diablo Game appears not to be running. Exiting...")
        Exit
    EndIf
    Return $ProcID
EndFunc   ;==>GetD2ProcessID

; ========================================

Func IsGameActive()

    ;; if game is active, then the game ping will be > 0

    $ping = ReadGamePing()
    If $ping > 0 Then
        Return 1
    Else
        Return 0
    EndIf

EndFunc   ;==>IsGameActive

; ========================================

Func ReadGamePing()

    Local $Value

    Local $ProcessID = GetD2ProcessID()
	$value = Read_Diablo_Memory($ProcessID, $OFFSET_Game_Ping, 'dword')

	Return $Value

EndFunc   ;==>ReadGamePing

; ========================================

Func IsIPFound($IP)
    ;; find last "." in IP address
    $lastDot = StringInStr($IP, ".", 0, 3)
    ;; find last part of IP address
    $lastPart = StringMid($IP, $lastDot + 1)

    ;; search for last part of IP in the HuntedIP array
    If $DebugForceFind Then
        $HuntedIPIsFound = 1
    Else
        $HuntedIPIsFound = 0
    EndIf

    For $r = 0 To UBound($HuntedIPs) - 1
        ;; MsgBox(4096, 'Comparing', "Comparing '" & $HuntedIPs[$r] & "' to '" & $lastPart & "'")
        If $HuntedIPs[$r] = $lastPart Then $HuntedIPIsFound = 1
    Next
    Return $HuntedIPIsFound
EndFunc   ;==>IsIPFound

; ========================================

Func _stopcheck()
	;Check if stop/pause after X Games
	if Not ($stopnum == 0) Then
;~ 		MsgBox(0,"stopdelay: " & $stopdelay,$gamenumber & @CRLF & $stopnum & @CRLF & Int($gamenumber/$stopnum) & @CRLF & ($gamenumber/$stopnum))
		if Int($gamenumber/$stopnum) == ($gamenumber/$stopnum) then
			if $stopdelay == -1 then
				ExitGame()
				sleep(1000)
				$HuntPaused = 1
				While $HuntPaused = 1
					Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
					_winoutput("Paused" & StringMid($prev,StringInStr($prev,"|")))
					Sleep(500)
				WEnd
				Return
			else
				$stoppedtimer = TimerInit()
				local $ai = 0
				while TimerDiff($stoppedtimer) < $stopdelay
					$ai = $ai + 1
					;only do anti-idle every 30 seconds
					if $ai >= 30 Then
						$ai = 0
						AntiIdle()
					EndIf
					Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
					if int(($stopdelay-TimerDiff($stoppedtimer))/1000/60) == 0 Then
						_winoutput("Wait: " & int(($stopdelay-TimerDiff($stoppedtimer))/1000) & "s" & StringMid($prev,StringInStr($prev,"|")))
					Else
						_winoutput("Wait: " & int(($stopdelay-TimerDiff($stoppedtimer))/1000/60) & "m" & StringMid($prev,StringInStr($prev,"|")))
					EndIf
					While $HuntPaused = 1
						Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
						_winoutput("Paused" & StringMid($prev,StringInStr($prev,"|")))
						Local $salemsg = GetLastChatMessage()
						If $salemsg <> "" Then
							If StringCompare($salemsg, $MESSAGE_DIABLO_WALKS_THE_EARTH , 1) = 0 Then
								_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
								_loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK")
								;; only check for messages if user has requested
								If $saleopt == 1 Then InterruptHunt()
							ElseIf StringCompare(StringRight($salemsg, StringLen($MESSAGE_STONES_OF_JORDAN_SOLD)), $MESSAGE_STONES_OF_JORDAN_SOLD,1) = 0 Then
								_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringReplace($salemsg,$MESSAGE_STONES_OF_JORDAN_SOLD,"",1,1) & "|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
								_loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringReplace($salemsg,$MESSAGE_STONES_OF_JORDAN_SOLD,"",1,1))
								;; only check for messages if user has requested
								If $saleopt == 1 Then InterruptHunt()
							EndIf
						EndIf
						Sleep(500)
					WEnd
					sleep(500)
				wend
			endif
		Endif
	endif
	;Check if stop/pause after X Time
	if Not ($stoptime == 0) Then
		if TimerDiff($stoptimer) >= $stoptime then
			if $stopdelay == -1 then
				ExitGame()
				sleep(1000)
				$HuntPaused = 1
				While $HuntPaused = 1
					Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
					_winoutput("Paused" & StringMid($prev,StringInStr($prev,"|")))
					Sleep(500)
				WEnd
				Return
			else
				$stoppedtimer = TimerInit()
				local $ai = 0
				while TimerDiff($stoppedtimer) < $stopdelay
					$ai = $ai + 1
					;only do anti-idle every 30 seconds
					if $ai >= 30 Then
						$ai = 0
						AntiIdle()
					EndIf
					Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
					if int(($stopdelay-TimerDiff($stoppedtimer))/1000/60) == 0 Then
						_winoutput("Wait: " & int(($stopdelay-TimerDiff($stoppedtimer))/1000) & "s" & StringMid($prev,StringInStr($prev,"|")))
					Else
						_winoutput("Wait: " & int(($stopdelay-TimerDiff($stoppedtimer))/1000/60) & "m" & StringMid($prev,StringInStr($prev,"|")))
					EndIf
					While $HuntPaused = 1
						Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
						_winoutput("Paused" & StringMid($prev,StringInStr($prev,"|")))
						Local $salemsg = GetLastChatMessage()
						If $salemsg <> "" Then
							If StringCompare($salemsg, $MESSAGE_DIABLO_WALKS_THE_EARTH , 1) = 0 Then
								_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
								_loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK")
								;; only check for messages if user has requested
								If $saleopt == 1 Then InterruptHunt()
							ElseIf StringCompare(StringRight($salemsg, StringLen($MESSAGE_STONES_OF_JORDAN_SOLD)), $MESSAGE_STONES_OF_JORDAN_SOLD,1) = 0 Then
								_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringReplace($salemsg,$MESSAGE_STONES_OF_JORDAN_SOLD,"",1,1) & "|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
								_loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringReplace($salemsg,$MESSAGE_STONES_OF_JORDAN_SOLD,"",1,1))
								;; only check for messages if user has requested
								If $saleopt == 1 Then InterruptHunt()
							EndIf
						EndIf
						Sleep(500)
					WEnd
					sleep(500)
				wend
			endif
			$stoptimer = TimerInit()
		Endif
	endif
EndFunc

; ========================================

Func ExitGame()
    $HoldGame = 0

    ;; only try to exit if a game's not active

    If IsGameActive() Then
        _SendMinimized($WindowName, '{ESC}')
        Sleep(500)
		_SendMinimized($WindowName, '{UP}')
		Sleep(100)
		_SendMinimized($WindowName, '{ENTER}')

        ;; wait for screen to change
        $retries = 0
        While (Not IsLobbyScreenUp() And $retries < 20)
            Sleep(500)
            $retries = $retries + 1
        WEnd

    Else
;~         AppendLineToLogText( "Game is already inactive; attempting to continue without exiting.")
    EndIf
	If IsGameActive() Then
;~ 		AppendLineToLogText( "Failed to exit game. trying alternate method")
		_SendMinimized($WindowName, "{SPACE}{SPACE}")
        Sleep(100)

        _SendMinimized($WindowName, '{ESC}')
        Sleep(500)
        _MouseClickMinimized($WindowName, "left", 439, 259,1,1)  ;; coordinates of "Save and Exit Game"
		Sleep(500)
		_MouseClickMinimized($WindowName, "left", 439, 259,1,1)  ;; coordinates of "Save and Exit Game"

        ;; wait for screen to change
        $retries = 0
        While (Not IsLobbyScreenUp() And $retries < 20)
            Sleep(500)
            $retries = $retries + 1
        WEnd
	EndIf

    VerifyLobbyScreenUp()
    Return

EndFunc   ;==>ExitGame

; ========================================

Func AckHuntedIPFound()
    $HoldGame = 1

	getgamenamepass()
	_loginfo("Found: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
	_winoutput("Found Game|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)

    ;; Give the user a chance to acknowledge the game has been found, NOT repeating the sound
	SoundPlay($FoundSoundFile)
;~ 	TrayTip("Success!!!", "Hunted IP " & $CurrentIP & " has been found!!!" & @CRLF & "Game name: " & $GameName & @CRLF & "Game password: " & $GamePass & @CRLF & "Currently anti-idling - will auto-rejoin if dropped.", "", 1)
    $ai = 0
	while not IsLobbyScreenUp()
		if $HoldGame = 0 Then
			_winoutput("Leaving Game|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
			ExitGame()
			For $sleepSecond = $DelayBeforeNewGameSeconds To 0 Step - 0.5
				_winoutput("lobby; Delay: " & Int($sleepSecond) & "| | |" & $successtotal & "/" & $GameNumber)
				While $HuntPaused = 1
					Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
					_winoutput("Paused" & StringMid($prev,StringInStr($prev,"|")))
					Sleep(500)
				WEnd
				Sleep(500)
			Next
			VerifyLobbyScreenUp()
			_Main()
		EndIf

		;; check for SOJ sales and/or Diablo Walks here and display them
		Local $salemsg = GetLastChatMessage()
		If $salemsg <> "" Then
			If StringCompare($salemsg, $MESSAGE_DIABLO_WALKS_THE_EARTH , 1) = 0 Then
				_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK |" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
				_loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK")
			ElseIf StringCompare(StringRight($salemsg, StringLen($MESSAGE_STONES_OF_JORDAN_SOLD)), $MESSAGE_STONES_OF_JORDAN_SOLD,1) = 0 Then
				_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringReplace($salemsg,$MESSAGE_STONES_OF_JORDAN_SOLD,"",1,1) & " |" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
				_loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringReplace($salemsg,$MESSAGE_STONES_OF_JORDAN_SOLD,"",1,1))
			EndIf
		EndIf

		$ai = $ai + 1
		;only do anti-idle every 30 seconds
		if $ai >= 30 Then
			$ai = 0
			AntiIdle()
		EndIf

        Sleep(1000)
    WEnd
    Sleep(500)

	;; Give the user a chance to acknowledge the game has been dropped
	SoundPlay($DroppedSoundFile)

    RejoinLostGameIP()

    Return

EndFunc   ;==>AckHuntedIPFound

; ========================================

Func RejoinLostGameIP()

		;; click "Join" button
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y,1,1)
		Sleep(400)


;~         AppendLineToLogText( "Attempting to rejoin game: " & $GameName & "//" & $GamePass)
		_loginfo("Rejoining: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
		_winoutput("Rejoining Game|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)

        _SendMinimized($WindowName, $GameName & '{TAB}')
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, $GamePass)
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, '{ENTER}')

        $RetryCount = 0
    Do
        If IsGameActive() Then
;~ 			AppendLineToLogText( "Successfilly rejoined game!")
            AckHuntedIPFound()
        EndIf
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 30

;~ 	AppendLineToLogText( "Failed to rejoin game; Continuing hunting")
	_winoutput("Hunting again| | |" & $successtotal & "/" & $GameNumber)
	$HoldGame = 0
;~     GUICtrlSetData($HoldAbandonButton, "Hold Game")
;~ 	GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
	_Main()

EndFunc

; ========================================

Func InterruptHunt()
    $HoldGame = 1

	getgamenamepass()
	_loginfo("Sells: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
	_winoutput("Detected Sells|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)

    ;; Give the user a chance to acknowledge the game is being held, NOT repeating the sound
    SoundPlay($FoundSoundFile)
;~ 	TrayTip("Possible success!!!", "Chat messages indicate activity on " & $CurrentIP & @CRLF & "Game name: " & $GameName & @CRLF & "Game password: " & $GamePass & @CRLF & "Currently anti-idling - will auto-rejoin if dropped.", "", 1)
    $ai = 0
	while not IsLobbyScreenUp()
		if $HoldGame = 0 Then
			_winoutput("Leaving Game|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
			ExitGame()
			For $sleepSecond = $DelayBeforeNewGameSeconds To 0 Step - 0.5
				_winoutput("lobby; Delay: " & Int($sleepSecond) & "| | |" & $successtotal & "/" & $GameNumber)
				While $HuntPaused = 1
					Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
					_winoutput("Paused" & StringMid($prev,StringInStr($prev,"|")))
					Sleep(500)
				WEnd
				Sleep(500)
			Next
			VerifyLobbyScreenUp()
			_Main()
		EndIf

		;; check for SOJ sales and/or Diablo Walks here and display them
		Local $salemsg = GetLastChatMessage()
		If $salemsg <> "" Then
			If StringCompare($salemsg, $MESSAGE_DIABLO_WALKS_THE_EARTH , 1) = 0 Then
				_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK |" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
				_loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK")
			ElseIf StringCompare(StringRight($salemsg, StringLen($MESSAGE_STONES_OF_JORDAN_SOLD)), $MESSAGE_STONES_OF_JORDAN_SOLD,1) = 0 Then
				_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringReplace($salemsg,$MESSAGE_STONES_OF_JORDAN_SOLD,"",1,1) & " |" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
				_loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringReplace($salemsg,$MESSAGE_STONES_OF_JORDAN_SOLD,"",1,1))
			EndIf
		EndIf

		$ai = $ai + 1
		;only do anti-idle every 30 seconds
		if $ai >= 30 Then
			$ai = 0
			AntiIdle()
		EndIf

        Sleep(1000)
    WEnd
    Sleep(500)

	;; Give the user a chance to acknowledge the game has been dropped
	SoundPlay($DroppedSoundFile)

    RejoinLostGameInt()

    Return

EndFunc   ;==>InterruptHunt

; ============================================

Func RejoinLostGameInt()

		;; click "Join" button
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y,1,1)
		Sleep(400)

;~         AppendLineToLogText( "Attempting to rejoin game: " & $GameName & "//" & $GamePass)
		_loginfo("Rejoining game: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
		_winoutput("Rejoining Game|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)

        _SendMinimized($WindowName, $GameName & '{TAB}')
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, $GamePass)
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, '{ENTER}')

        $RetryCount = 0
    Do
        If IsGameActive() Then
;~ 			AppendLineToLogText( "Successfilly rejoined game!")
            InterruptHunt()
        EndIf
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 30

;~ 	AppendLineToLogText( "Failed to rejoin game; Continuing hunting")
;~ 	GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
	_winoutput("Hunting again| | |" & $successtotal & "/" & $GameNumber)
	$HoldGame = 0
;~     GUICtrlSetData($HoldAbandonButton, "Hold Game")
	_Main()

EndFunc

; ========================================

Func HoldManualGame()
    $HoldGame = 1

	getgamenamepass()
	$CurrentIP = Read_Diablo_Memory (GetD2ProcessID(), $OFFSET_D2MULTI_IPADDRESS_ASCII, 'char[16]')
	_loginfo("Holding game: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
	_winoutput("Held Game|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)


    ;; Give the user a chance to acknowledge the game is being held, no sound
    $ai = 0
	while not IsLobbyScreenUp()
		if $HoldGame = 0 Then
			_winoutput("Leaving Game|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
			ExitGame()
			For $sleepSecond = $DelayBeforeNewGameSeconds To 0 Step - 0.5
				_winoutput("lobby; Delay: " & Int($sleepSecond) & "| | |" & $successtotal & "/" & $GameNumber)
				While $HuntPaused = 1
					Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
					_winoutput("Paused" & StringMid($prev,StringInStr($prev,"|")))
					Sleep(500)
				WEnd
				Sleep(500)
			Next
			VerifyLobbyScreenUp()
			_Main()
		EndIf

		;; check for SOJ sales and/or Diablo Walks here and display them
		Local $salemsg = GetLastChatMessage()
		If $salemsg <> "" Then
			If StringCompare($salemsg, $MESSAGE_DIABLO_WALKS_THE_EARTH , 1) = 0 Then
				_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK |" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
				_loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK")
			ElseIf StringCompare(StringRight($salemsg, StringLen($MESSAGE_STONES_OF_JORDAN_SOLD)), $MESSAGE_STONES_OF_JORDAN_SOLD,1) = 0 Then
				_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringReplace($salemsg,$MESSAGE_STONES_OF_JORDAN_SOLD,"",1,1) & " |" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
				_loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringReplace($salemsg,$MESSAGE_STONES_OF_JORDAN_SOLD,"",1,1))
			EndIf
		EndIf

		$ai = $ai + 1
		;only do anti-idle every 30 seconds
		if $ai >= 30 Then
			$ai = 0
			AntiIdle()

		EndIf

        Sleep(1000)
    WEnd
    Sleep(500)

	;; Give the user a chance to acknowledge the game has been dropped
	SoundPlay($DroppedSoundFile)

    RejoinLostGameHold()

    Return

EndFunc

; ============================================

Func RejoinLostGameHold()

		;; click "Join" button
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y,1,1)
		Sleep(400)


;~         AppendLineToLogText( "Attempting to rejoin game: " & $GameName & "//" & $GamePass)
		_loginfo("Rejoining: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
		_winoutput("Rejoining Game|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)

        _SendMinimized($WindowName, $GameName & '{TAB}')
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, $GamePass)
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, '{ENTER}')

        $RetryCount = 0
    Do
        If IsGameActive() Then
            HoldManualGame()
        EndIf
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 30

;~ 	AppendLineToLogText( "Failed to rejoin game; Continuing hunting")
;~ 	GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
	_winoutput("Hunting again| | |" & $successtotal & "/" & $GameNumber)
	$HoldGame = 0
;~     GUICtrlSetData($HoldAbandonButton, "Hold Game")
	_Main()

EndFunc

Func _joinGame()
        VerifyLobbyScreenUp()

		$GameName = $joinGameName
		$GamePass = $joinGamePass

		;; click "Join" button
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y,1,1)
		Sleep(400)

		_winoutput("Joining Game|" & $GameName & "//" & $GamePass & "| |" & $successtotal & "/" & $GameNumber)

        _SendMinimized($WindowName, $GameName & '{TAB}')
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, $GamePass)
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, '{ENTER}')

        $RetryCount = 0
    Do
        If IsGameActive() Then
            HoldManualGame()
        EndIf
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 30

;~ 	AppendLineToLogText( "Failed to rejoin game; Continuing hunting")_wipeentry($windowtitlearray[$i][1]) ;clear data entry and remove from GUI
;~ 	GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
	_winoutput("Hunting again| | |" & $successtotal & "/" & $GameNumber)
	$HoldGame = 0
;~     GUICtrlSetData($HoldAbandonButton, "Hold Game")
	_Main()

EndFunc

; ========================================

Func AntiIdle()

    If IsGameActive() Then
		;; anti-idle with random "vocal" message ("time to die!", etc.)
		_SendMinimized($WindowName, "{NUMPAD" & Random(0, 7, 1) & "}")
	Else
		If Not IsLobbyScreenUp() Then
			;; Give the user a chance to acknowledge the game has been dropped
			SoundPlay($DroppedSoundFile)
			_loginfo("Game Dropped!: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
			_winoutput("Game Dropped!|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
		EndIf
;~         AppendLineToLogText("Sorry. The game on the hunted IP " & $CurrentIP & " appears to have dropped")
;~ 		GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
;~         $userResponse = MsgBox(32, $VersionInfo & ": Problem", "Game " & $GameName & "//" & $GamePass & " appears to be lost (disconnected?). Check your Diablo II window.")
;~         Exit
    EndIf

EndFunc   ;==>AntiIdle

; ============================================

Func GetLastChatMessage()

    $Handle = _MemoryOpen (GetD2ProcessID())
    Local $pointer1 = _MemoryRead ($OFFSET_D2MULTI_LAST_CHAT_MSG, $Handle, 'dword')
    Local $pointer2 = _MemoryRead ($pointer1, $Handle, 'dword')
    Local $Temp = _MemoryReadWideString ($pointer2, $Handle, 'ushort[396]')
	_MemoryClose ($Handle)
	If ($oldptr1 == $pointer1) And ($oldptr2 == $pointer2) And ($oldmsg == $Temp) Then
		Return ""
	Else
		$oldptr1 = $pointer1
		$oldptr2 = $pointer2
		$oldmsg = $Temp
		Return $Temp
	EndIf
EndFunc   ;==>GetLastChatMessage

;===============================================================================
;
; Function Name:  _SendMinimized()
;===============================================================================
Func _SendMinimized($Window, $keys)
    ;; note : testing with D2 shows that sending {ENTER} to open the chat screen
    ;;   requires that the D2 window be shown. Otherwise, all other keystrokes
    ;;   seem to be ingored, and the client stays in the chat mode.
	_SendMinimizedMessage($Window,$keys)

EndFunc   ;==>_SendMinimized

;========================================================

Func _ProcessGetLoadedModules($iPID)
    Local Const $PROCESS_QUERY_INFORMATION=0x0400
    Local Const $PROCESS_VM_READ=0x0010
    Local $aCall, $hPsapi=DllOpen("Psapi.dll")
    Local $hProcess, $tModulesStruct
    $tModulesStruct=DllStructCreate("hwnd [200]")
    Local $SIZEOFHWND = DllStructGetSize($tModulesStruct)/200
    $hProcess=_WinAPI_OpenProcess(BitOR($PROCESS_QUERY_INFORMATION,$PROCESS_VM_READ),False,$iPID)
    If Not $hProcess Then Return SetError(1,0,-1)
    $aCall=DllCall($hPsapi,"int","EnumProcessModules","ptr",$hProcess,"ptr",DllStructGetPtr($tModulesStruct),"dword",DllStructGetSize($tModulesStruct),"dword*","")
    If $aCall[4]>DllStructGetSize($tModulesStruct) Then
        $tModulesStruct=DllStructCreate("hwnd ["&$aCall[4]/$SIZEOFHWND&"]")
        $aCall=DllCall($hPsapi,"int","EnumProcessModules","ptr",$hProcess,"ptr",DllStructGetPtr($tModulesStruct),"dword",$aCall[4],"dword*","")
    EndIf
    Local $aReturn[$aCall[4]/$SIZEOFHWND]
	Local $returnval = 0
    For $i=0 To Ubound($aReturn)-1
        $aCall=DllCall($hPsapi,"dword","GetModuleFileNameExW","ptr",$hProcess,"int",DllStructGetData($tModulesStruct,1,$i+1),"wstr","","dword",65536)
		if (StringRight($aCall[3]	,13) = "\d2client.dll") Then
;~ 			MsgBox(0,$i,$aCall[3] & @CRLF & DllStructGetData($tModulesStruct,1,$i+1))
			$returnval = DllStructGetData($tModulesStruct,1,$i+1)
		EndIf
        $aReturn[$i]=$aCall[3]
    Next
    _WinAPI_CloseHandle($hProcess)
    DllClose($hPsapi)
    Return $returnval
EndFunc

;;writes entry to a log file
Func _loginfo($message)
	if Not ($message == "") Then
		ControlSetText("KCHClient-" & @AutoItPID,"",5,_NowTime() & " " & $WindowName & " " & $message)
	EndIf
EndFunc

;;get input info from program's window
Func _getwininput()
	Local $input = ControlGetText("KCHClient-" & @AutoItPID,"",3)
	ControlSetText("KCHClient-" & @AutoItPID,"",3,"input")
	if $input = "exit" Then Exit ;input
	if $input = "leave" Then $HoldGame = 0
	if $input = "pause" Then
		if $HuntPaused = 0 Then
			Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
			_winoutput("Paused" & StringMid($prev,StringInStr($prev,"|")))
			$HuntPaused = 1
		ElseIf $HuntPaused = 1 Then
			$HuntPaused = 0
		EndIf
	EndIf
	if StringLeft($input,5) = "join:" Then
		if StringInStr($input,"/") > 0 Then
		Local $value = StringSplit(StringReplace(StringMid($input,6),"//","/"), "/")
		$joinGameName = $value[1]
		$joinGamePass = $value[2]
		$JoinGame = 1
	Else
		$joinGameName = StringMid($input,6)
		$joinGamePass = ""
		$JoinGame = 1
	EndIf

	EndIf
	if StringLeft($input,6) = "chgip:" Then
		Local $val = 1
		$IPList_old = $IPList
		Do
			$InputIPList = StringMid($input,7)

			$InputIPList = StringStripWS($InputIPList, 8)  ;; strip all spaces
			$SplitIPs = StringSplit($InputIPList, ",")  ;; breaks IPs into separate array entries
		Until $SplitIPs[0] >= 1

		;; first element of array after Split is number of returned elements
		ReDim $HuntedIPs [$SplitIPs[0]]
		$IPList = ""

		For $r = 1 To UBound($SplitIPs) - 1
			$HuntedIPs[$r - 1] = $SplitIPs[$r]  ;; copy IP into hunting list
			If $IPList = "" Then
				$IPList = $SplitIPs[$r]  ;; init to first split IP
			Else
				$IPList = $IPList & ", " & $SplitIPs[$r]
			EndIf

		Next

		$changedip = 1
	EndIf
	if StringLeft($input,6) = "delay:" Then $GameDurationSeconds = StringMid($input,7)
	if (StringLeft($input,6) = "start|") And ($startinfo = 0) Then
;~ 		MsgBox(0,"Startup",$input)
		Local $string = StringSplit($input,"|")
		;winhandle info
		$WindowName = $string[2]
		;difficulty info
		if $string[3] = "n" Then
			$LOBBY_CREATE_X = $LOBBY_CREATE_NORM_X
			$LOBBY_CREATE_Y = $LOBBY_CREATE_NORM_Y
		ElseIf $string[3] = "h" Then
			$LOBBY_CREATE_X = $LOBBY_CREATE_HELL_X
			$LOBBY_CREATE_Y = $LOBBY_CREATE_HELL_Y
		EndIf
		;ip info
		$InputIPList = StringStripWS($string[4], 8)  ;; strip all spaces
		$SplitIPs = StringSplit($InputIPList, ",")  ;; breaks IPs into separate array entries
		ReDim $HuntedIPs [$SplitIPs[0]]
		$IPList = ""
		For $r = 1 To UBound($SplitIPs) - 1
			$HuntedIPs[$r - 1] = $SplitIPs[$r]  ;; copy IP into hunting list
			If $IPList = "" Then
				$IPList = $SplitIPs[$r]  ;; init to first split IP
			Else
				$IPList = $IPList & ", " & $SplitIPs[$r]
			EndIf
		Next
		;duration info
		$GameDurationSeconds = $string[5]
		;prefix info
		$UserUniqueGameName = $string[6]
		;pass info
		if Not ($string[7] == "(default)") Then $UserUniqueGamePass = $string[7]
		;diablo pid, cuz autoit sucks at getting the pid from a handle as string
		$winprocess = $string[8]
		;start delay
		$startdelay = $string[9]
		;delaybeforenewgame
		$DelayBeforeNewGameSeconds = $string[10]
		;Sale Interrupt Setting
		$saleopt = $string[11]
		;Set as retrieved start info
		$startinfo = 1
		$stopnum = $string[12]
		$stoptime = ($string[13]*60*1000)
		if Not ($string[14] == -1) Then
			$stopdelay = ($string[14]*60*1000)
		Else
			$stopdelay = -1
		EndIf
	EndIf


;~ 	_winoutput(_NowCalc() & "| | |0/0")
	Sleep(50)
EndFunc

;output info back to parent program
Func _winoutput($message)
	ControlSetText("KCHClient-" & @AutoItPID,"",4,$message)
EndFunc
